/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.schematics;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.BlockBanner;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockSkull;
import net.minecraft.block.BlockStandingSign;
import net.minecraft.block.BlockVine;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import noppes.npcs.CustomNpcs;
import noppes.npcs.controllers.SchematicController;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.items.ItemBuilder;
import noppes.npcs.items.ItemPlacer;
import noppes.npcs.schematics.ISchematic;
import noppes.npcs.schematics.SchematicBlockData;
import noppes.npcs.util.BuilderData;

public class SchematicWrapper {
    public boolean isBuilding = false;
    public boolean isBlock = true;
    public int layer = 0;
    public int buildPos;
    public int size;
    public int rotation = 0;
    public int buildingPercentage;
    private long time = 0L;
    public ISchematic schema;
    public BlockPos start;
    public Map<String, NBTTagCompound> tileEntities;
    public World world;
    public ICommandSender sender;
    private BuilderData builder;
    private List<SchematicBlockData> listB = new ArrayList<SchematicBlockData>();
    private List<Entity> listE = new ArrayList<Entity>();

    public static Entity rotatePos(Entity entity, int rotation, BlockPos pos, BlockPos offset) {
        if (entity == null) {
            return null;
        }
        if (entity instanceof EntityHanging) {
            EntityHanging eh = (EntityHanging)entity;
            double x = eh.field_70165_t;
            double y = eh.field_70163_u - (double)offset.func_177956_o();
            double z = eh.field_70161_v;
            eh.field_70177_z = (eh.field_70177_z + (float)rotation * 90.0f) % 360.0f;
            switch (rotation) {
                case 1: 
                case 2: {
                    x += (double)offset.func_177958_n() * -1.0;
                    z += -1.0 - (double)offset.func_177952_p();
                    break;
                }
                case 3: {
                    x += 1.0 + (double)offset.func_177958_n() * -1.0;
                    z += -1.0 - (double)offset.func_177952_p();
                    break;
                }
                default: {
                    x -= (double)offset.func_177958_n();
                    z -= (double)offset.func_177952_p();
                }
            }
            x += (double)pos.func_177958_n();
            y += (double)pos.func_177956_o();
            z += (double)pos.func_177952_p();
            for (int i = 0; i < rotation; ++i) {
                assert (eh.field_174860_b != null);
                eh.field_174860_b = eh.field_174860_b.func_176746_e();
            }
            entity.func_70107_b(x, y, z);
            return entity;
        }
        double x = entity.field_70165_t;
        double y = entity.field_70163_u;
        double z = entity.field_70161_v;
        switch (rotation) {
            case 1: {
                x = 1.0 + (double)offset.func_177952_p() - entity.field_70161_v;
                z = 1.0 + entity.field_70165_t + (double)offset.func_177958_n() * -1.0;
                break;
            }
            case 2: {
                x = 1.0 + entity.field_70165_t * -1.0 + (double)offset.func_177958_n();
                z = 1.0 + entity.field_70161_v * -1.0 + (double)offset.func_177952_p();
                break;
            }
            case 3: {
                x = 1.0 + entity.field_70161_v - (double)offset.func_177952_p();
                z = 1.0 + entity.field_70165_t * -1.0 + (double)offset.func_177958_n();
                break;
            }
            default: {
                x += 1.0 - (double)offset.func_177958_n();
                z += 1.0 - (double)offset.func_177952_p();
            }
        }
        entity.field_70177_z = (entity.field_70177_z + (float)rotation * 90.0f) % 360.0f;
        entity.field_70165_t = x + (double)pos.func_177958_n() + 0.5;
        entity.field_70163_u = y + (double)pos.func_177956_o();
        entity.field_70161_v = z + (double)pos.func_177952_p() + 0.5;
        if (entity instanceof EntityCreature) {
            ((EntityCreature)entity).func_175449_a(entity.func_180425_c(), (int)((EntityCreature)entity).func_110174_bM());
        }
        if (entity instanceof EntityNPCInterface) {
            ((EntityNPCInterface)entity).ais.orientation = (((EntityNPCInterface)entity).ais.orientation + rotation * 90) % 360;
        }
        return entity;
    }

    public static IBlockState rotationState(IBlockState state, int rotation) {
        if (rotation == 0) {
            return state;
        }
        if (state.func_177230_c() instanceof BlockVine) {
            int d = state.func_177230_c().func_176201_c(state);
            block28: for (int i = 0; i < rotation; ++i) {
                switch (d) {
                    case 1: {
                        d = 2;
                        continue block28;
                    }
                    case 2: {
                        d = 4;
                        continue block28;
                    }
                    case 4: {
                        d = 8;
                        continue block28;
                    }
                    case 8: {
                        d = 1;
                        continue block28;
                    }
                }
            }
            return state.func_177230_c().func_176223_P().func_177226_a((IProperty)BlockVine.field_176279_N, (Comparable)Boolean.valueOf((d & 1) > 0)).func_177226_a((IProperty)BlockVine.field_176280_O, (Comparable)Boolean.valueOf((d & 2) > 0)).func_177226_a((IProperty)BlockVine.field_176273_b, (Comparable)Boolean.valueOf((d & 4) > 0)).func_177226_a((IProperty)BlockVine.field_176278_M, (Comparable)Boolean.valueOf((d & 8) > 0));
        }
        ImmutableSet set = state.func_177228_b().keySet();
        for (IProperty prop : set) {
            if (prop.func_177699_b() == BlockLog.EnumAxis.class) {
                BlockLog.EnumAxis d = (BlockLog.EnumAxis)state.func_177229_b(prop);
                if (d == BlockLog.EnumAxis.Y || d == BlockLog.EnumAxis.NONE) continue;
                for (int i = 0; i < rotation; ++i) {
                    d = d == BlockLog.EnumAxis.X ? BlockLog.EnumAxis.Z : BlockLog.EnumAxis.X;
                }
                return state.func_177226_a(prop, (Comparable)d);
            }
            if (prop.func_177699_b() == EnumFacing.class) {
                EnumFacing d = (EnumFacing)state.func_177229_b(prop);
                if (d == EnumFacing.UP || d == EnumFacing.DOWN) continue;
                for (int i = 0; i < rotation; ++i) {
                    d = d.func_176746_e();
                }
                return state.func_177226_a(prop, (Comparable)d);
            }
            if (prop.func_177699_b() == BlockRailBase.EnumRailDirection.class) {
                BlockRailBase.EnumRailDirection d = (BlockRailBase.EnumRailDirection)state.func_177229_b(prop);
                block32: for (int i = 0; i < rotation; ++i) {
                    switch (d) {
                        case NORTH_SOUTH: {
                            d = BlockRailBase.EnumRailDirection.EAST_WEST;
                            continue block32;
                        }
                        case EAST_WEST: {
                            d = BlockRailBase.EnumRailDirection.NORTH_SOUTH;
                            continue block32;
                        }
                        case ASCENDING_EAST: {
                            d = BlockRailBase.EnumRailDirection.ASCENDING_SOUTH;
                            continue block32;
                        }
                        case ASCENDING_WEST: {
                            d = BlockRailBase.EnumRailDirection.ASCENDING_NORTH;
                            continue block32;
                        }
                        case ASCENDING_NORTH: {
                            d = BlockRailBase.EnumRailDirection.ASCENDING_EAST;
                            continue block32;
                        }
                        case ASCENDING_SOUTH: {
                            d = BlockRailBase.EnumRailDirection.ASCENDING_WEST;
                            continue block32;
                        }
                        case SOUTH_EAST: {
                            d = BlockRailBase.EnumRailDirection.SOUTH_WEST;
                            continue block32;
                        }
                        case SOUTH_WEST: {
                            d = BlockRailBase.EnumRailDirection.NORTH_WEST;
                            continue block32;
                        }
                        case NORTH_WEST: {
                            d = BlockRailBase.EnumRailDirection.NORTH_EAST;
                            continue block32;
                        }
                        case NORTH_EAST: {
                            d = BlockRailBase.EnumRailDirection.SOUTH_EAST;
                        }
                    }
                }
                return state.func_177226_a(prop, (Comparable)d);
            }
            if (prop.func_177699_b() == BlockLever.EnumOrientation.class) {
                BlockLever.EnumOrientation d = (BlockLever.EnumOrientation)state.func_177229_b(prop);
                block33: for (int i = 0; i < rotation; ++i) {
                    switch (d) {
                        case DOWN_X: {
                            d = BlockLever.EnumOrientation.DOWN_Z;
                            continue block33;
                        }
                        case DOWN_Z: {
                            d = BlockLever.EnumOrientation.DOWN_X;
                            continue block33;
                        }
                        case UP_X: {
                            d = BlockLever.EnumOrientation.UP_Z;
                            continue block33;
                        }
                        case UP_Z: {
                            d = BlockLever.EnumOrientation.UP_X;
                            continue block33;
                        }
                        case EAST: {
                            d = BlockLever.EnumOrientation.SOUTH;
                            continue block33;
                        }
                        case WEST: {
                            d = BlockLever.EnumOrientation.NORTH;
                            continue block33;
                        }
                        case SOUTH: {
                            d = BlockLever.EnumOrientation.WEST;
                            continue block33;
                        }
                        case NORTH: {
                            d = BlockLever.EnumOrientation.EAST;
                        }
                    }
                }
                return state.func_177226_a(prop, (Comparable)d);
            }
            if (prop.func_177699_b() != Integer.class) continue;
            int d = (Integer)state.func_177229_b(prop);
            if (!(state.func_177230_c() instanceof BlockBanner.BlockBannerStanding) && !(state.func_177230_c() instanceof BlockStandingSign)) continue;
            d %= 16;
            for (int i = 0; i < rotation; ++i) {
                d = d <= 12 ? 4 + d : 4 + d - 16;
            }
            return state.func_177226_a(prop, (Comparable)Integer.valueOf(d % 16));
        }
        return state;
    }

    public SchematicWrapper(ISchematic schematic) {
        this.start = BlockPos.field_177992_a;
        this.schema = schematic;
        this.size = schematic.getWidth() * schematic.getHeight() * schematic.getLength();
        this.tileEntities = new HashMap<String, NBTTagCompound>();
        this.sender = null;
        this.builder = null;
        for (int i = 0; i < schematic.getTileEntitySize(); ++i) {
            NBTTagCompound teTag = schematic.getTileEntity(i);
            this.tileEntities.put(teTag.func_74762_e("x") + "_" + teTag.func_74762_e("y") + "_" + teTag.func_74762_e("z"), teTag);
        }
    }

    public void build() {
        if (this.world == null || !this.isBuilding) {
            return;
        }
        long endPos = this.buildPos + CustomNpcs.MaxBuilderBlocks;
        if (endPos > (long)this.size) {
            endPos = this.size;
        }
        if (this.layer < 2) {
            if (this.layer == 0 && this.builder != null) {
                this.listB = new ArrayList<SchematicBlockData>();
                this.listE = new ArrayList<Entity>();
                BlockPos ps = this.start;
                BlockPos pe = this.start.func_177982_a((int)(this.rotation % 2 == 0 ? this.schema.getWidth() : this.schema.getLength()), (int)this.schema.getHeight(), (int)(this.rotation % 2 == 0 ? this.schema.getLength() : this.schema.getWidth()));
                List list = new ArrayList();
                try {
                    list = this.world.func_72872_a(Entity.class, new AxisAlignedBB((double)ps.func_177958_n() - 0.5, (double)ps.func_177956_o() - 0.5, (double)ps.func_177952_p() - 0.5, (double)pe.func_177958_n() + 0.5, (double)pe.func_177956_o() + 0.5, (double)pe.func_177952_p() + 0.5));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                for (Entity e : list) {
                    if (e instanceof EntityThrowable || e instanceof EntityArrow || e instanceof EntityPlayer) continue;
                    this.listE.add(e);
                    e.field_70128_L = true;
                }
            }
            long t = System.currentTimeMillis();
            while ((long)this.buildPos < endPos) {
                int x = this.buildPos % this.schema.getWidth();
                int z = (this.buildPos - x) / this.schema.getWidth() % this.schema.getLength();
                int y = ((this.buildPos - x) / this.schema.getWidth() - z) / this.schema.getLength();
                SchematicBlockData sbd = this.place(x, y, z, this.layer == 0);
                if (sbd != null) {
                    this.listB.add(sbd);
                }
                ++this.buildPos;
            }
            this.time += System.currentTimeMillis() - t;
        }
        if (this.buildPos >= this.size) {
            switch (this.layer) {
                case 0: {
                    this.layer = 1;
                    this.buildPos = 0;
                    break;
                }
                case 1: {
                    if (this.schema.hasEntitys()) {
                        NBTTagList list = this.schema.getEntitys();
                        for (int i = 0; i < list.func_74745_c(); ++i) {
                            this.spawn(list.func_150305_b(i));
                        }
                    }
                    this.layer = 2;
                    SchematicController.time = this.time / ((long)this.schema.getHeight() * (long)this.schema.getLength() * (long)this.schema.getWidth());
                    this.time = 0L;
                    break;
                }
                default: {
                    this.layer = 3;
                    this.isBuilding = false;
                    if (this.builder == null) break;
                    this.builder.add(this.listB, this.listE);
                }
            }
        }
    }

    public NBTTagCompound getNBTSmall() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74777_a("Width", this.schema.getWidth());
        compound.func_74777_a("Height", this.schema.getHeight());
        compound.func_74777_a("Length", this.schema.getLength());
        compound.func_74778_a("SchematicName", this.schema.getName());
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.size && i < 25000; ++i) {
            IBlockState state = this.schema.getBlockState(i);
            if (state.func_177230_c() == Blocks.field_150350_a || state.func_177230_c() == Blocks.field_189881_dj) {
                list.func_74742_a((NBTBase)new NBTTagCompound());
                continue;
            }
            list.func_74742_a((NBTBase)NBTUtil.func_190009_a((NBTTagCompound)new NBTTagCompound(), (IBlockState)this.schema.getBlockState(i)));
        }
        compound.func_74782_a("Data", (NBTBase)list);
        return compound;
    }

    public int getPercentage() {
        double l = this.buildPos + (this.layer == 0 ? 0 : this.size);
        return (int)(l / (double)this.size * 50.0);
    }

    public NBTTagCompound getTileEntity(int x, int y, int z, BlockPos pos) {
        NBTTagCompound compound = this.tileEntities.get(x + "_" + y + "_" + z);
        if (compound == null) {
            return null;
        }
        compound = compound.func_74737_b();
        compound.func_74768_a("x", pos.func_177958_n());
        compound.func_74768_a("y", pos.func_177956_o());
        compound.func_74768_a("z", pos.func_177952_p());
        return compound;
    }

    public void init(BlockPos pos, World world, int rotation) {
        this.start = pos;
        this.world = world;
        this.rotation = rotation;
        this.isBuilding = true;
        this.buildingPercentage = 0;
        this.layer = 0;
        this.isBlock = true;
        this.time = 0L;
    }

    public SchematicBlockData place(int x, int y, int z, boolean firstLayer) {
        NBTTagCompound comp;
        TileEntity tile;
        IBlockState state = this.schema.getBlockState(x, y, z);
        if (state == null || firstLayer && !state.func_185913_b() && state.func_177230_c() != Blocks.field_150350_a || !firstLayer && (state.func_185913_b() || state.func_177230_c() == Blocks.field_150350_a)) {
            return null;
        }
        int rotation = this.rotation / 90;
        BlockPos pos = this.start.func_177971_a((Vec3i)this.rotatePos(x, y, z, rotation));
        SchematicBlockData sbd = new SchematicBlockData(this.world, this.world.func_180495_p(pos), pos);
        state = SchematicWrapper.rotationState(state, rotation);
        if (this.builder != null) {
            if (state.func_177230_c() == Blocks.field_150350_a && !this.builder.addAir) {
                return null;
            }
            if (sbd.state != null) {
                if (!this.builder.replaceAir && sbd.state.func_177230_c() != Blocks.field_150350_a && sbd.state.func_177230_c().func_181623_g()) {
                    return null;
                }
                Material mat = sbd.state.func_177230_c().func_149688_o(sbd.state);
                if (mat.func_76222_j() && this.builder.isSolid) {
                    return null;
                }
            }
        }
        this.world.func_180501_a(pos, state, 2);
        if (state.func_177230_c() instanceof ITileEntityProvider && (tile = this.world.func_175625_s(pos)) != null && (comp = this.getTileEntity(x, y, z, pos)) != null) {
            if (rotation != 0 && state.func_177230_c() instanceof BlockSkull && comp.func_150297_b("Rot", 1)) {
                byte d = comp.func_74771_c("Rot");
                for (int i = 0; i < rotation; ++i) {
                    d = (byte)(d + 4);
                }
                d = (byte)(d % 16);
                comp.func_74774_a("Rot", d);
            }
            tile.func_145839_a(comp);
        }
        this.world.func_180501_a(pos, state, 2);
        return sbd;
    }

    public BlockPos rotatePos(int x, int y, int z, int rotation) {
        switch (rotation) {
            case 1: {
                return new BlockPos(this.schema.getLength() - z - 1, y, x);
            }
            case 2: {
                return new BlockPos(this.schema.getWidth() - x - 1, y, this.schema.getLength() - z - 1);
            }
            case 3: {
                return new BlockPos(z, y, this.schema.getWidth() - x - 1);
            }
        }
        return new BlockPos(x, y, z);
    }

    public void setBuilder(ICommandSender sender) {
        this.sender = sender;
        this.isBuilding = true;
        this.buildingPercentage = 0;
        this.isBlock = false;
        if (sender instanceof EntityPlayer && ((EntityPlayer)sender).func_184614_ca().func_77973_b() instanceof ItemPlacer) {
            this.builder = ItemBuilder.getBuilder(((EntityPlayer)sender).func_184614_ca(), (EntityPlayer)sender);
        }
    }

    public void spawn(NBTTagCompound entityNbt) {
        Entity entity = EntityList.func_75615_a((NBTTagCompound)entityNbt, (World)this.world);
        if (entity == null) {
            return;
        }
        UUID uuid = entity.func_110124_au();
        while (uuid != null) {
            boolean has = false;
            for (Entity e : this.world.field_72996_f) {
                if (!e.func_110124_au().equals(entity.func_110124_au())) continue;
                uuid = UUID.randomUUID();
                entity.func_184221_a(uuid);
                has = true;
                break;
            }
            if (has) continue;
            uuid = null;
        }
        entity = SchematicWrapper.rotatePos(entity, this.rotation / 90, this.start, this.schema.getOffset());
        this.world.func_72838_d(entity);
        if (entity instanceof EntityNPCInterface) {
            ((EntityNPCInterface)entity).reset(50);
        }
    }
}

